<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Group_Control_Image_Size;
extract($data);
$btn = $attr = '';
$svg='<svg 
		xmlns="http://www.w3.org/2000/svg"
		xmlns:xlink="http://www.w3.org/1999/xlink"
		width="24px" height="24px">
		<path fill-rule="evenodd"  fill="rgb(250, 54, 10)"
		d="M11.998,23.997 C5.381,23.997 -0.001,18.614 -0.001,11.998 C-0.001,5.382 5.381,-0.001 11.998,-0.001 C18.614,-0.001 23.997,5.382 23.997,11.998 C23.997,18.614 18.614,23.997 11.998,23.997 ZM11.998,2.181 C6.584,2.181 2.180,6.585 2.180,11.998 C2.180,17.412 6.584,21.815 11.998,21.815 C17.411,21.815 21.815,17.412 21.815,11.998 C21.815,6.585 17.411,2.181 11.998,2.181 ZM17.368,12.415 C17.312,12.548 17.232,12.669 17.131,12.770 L12.769,17.132 C12.556,17.346 12.277,17.452 11.998,17.452 C11.718,17.452 11.439,17.346 11.226,17.132 C10.800,16.706 10.800,16.016 11.226,15.590 L13.728,13.089 L7.634,13.089 C7.032,13.089 6.543,12.600 6.543,11.998 C6.543,11.396 7.032,10.907 7.634,10.907 L13.728,10.907 L11.226,8.406 C10.800,7.980 10.800,7.289 11.226,6.863 C11.652,6.437 12.343,6.437 12.769,6.863 L17.131,11.226 C17.232,11.327 17.312,11.447 17.368,11.581 C17.478,11.848 17.478,12.148 17.368,12.415 Z"/>
	 </svg>';
if ( !empty( $data['buttonurl']['url'] ) ) {
	$attr  = 'href="' . $data['buttonurl']['url'] . '"';
	$attr .= !empty( $data['buttonurl']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['buttonurl']['nofollow'] ) ? ' rel="nofollow"' : '';
}
if ( !empty( $data['buttontext'] ) ) {
	$btn = '<a class="btn-style3" ' . $attr . '>' . $data['buttontext'] .$svg. '</a>';
}

?>
<div class="cta-default cta-<?php echo esc_attr( $data['style'] ); ?>">
	<ul class="cta-element-list d-none d-xl-block">
				<li>
					<img class="wow fadeInDown" data-wow-delay="400ms" data-wow-duration="1200ms" src="<?php echo FINBUZZ_ASSETS_URL . 'element/cta-figure3.png'; ?>" alt="cta-figure3" width="257" height="196">
				</li>
				<li>
					<img class="wow fadeInUp" data-wow-delay="400ms" data-wow-duration="1200ms" src="<?php echo FINBUZZ_ASSETS_URL . 'element/cta-figure4.png'; ?>" alt="cta-figure4" width="358" height="275">
				</li>
	</ul>
	<div class="container">
		<div class="action-box">
			<div class="cta-content">
				<h2 class="cta-title"><?php echo wp_kses_post( $data['title'] );?></h2>
				<div class="cta-subtitle">
					<?php echo wp_kses_post( $data['sub_title'] );?>
				</div>
			</div>
			<div class="button-area">
					<?php if ( $btn ) { ?>
						<div class="button "><?php echo wp_kses_post( $btn );?></div>		
					<?php } ?>
			</div>	
		</div>
	</div>
</div>