<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;

use FinbuzzTheme_Helper;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
extract($data);

$attr = '';
if ( !empty( $data['url']['url'] ) ) {
	$attr  = 'href="' . $data['url']['url'] . '"';
	$attr .= !empty( $data['url']['is_external'] ) ? ' target="_blank"' : '';
	$attr .= !empty( $data['url']['nofollow'] ) ? ' rel="nofollow"' : '';
	
}
//image
if ( $attr ) {
  $getimg = '<a ' . $attr . '>' .Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size' , 'rt_image' ).'</a>';
}
else {
	$getimg = Group_Control_Image_Size::get_attachment_image_html( $data, 'icon_image_size', 'rt_image' );
}



$mouse_follow_effect="";
if($data['mouse_follow']=='yes'){
    $mouse_follow_effect="motion-effects-wrap";
}
?>

<div class="image-default image-<?php echo esc_attr( $data['style'] );?> <?php echo esc_attr( $mouse_follow_effect); ?>">
	<div class="image-box">
		<ul class="about-shape d-none d-xl-block">
			<li class=" motion-effects1">
				<img class="wow fadeInRight" src="<?php echo FINBUZZ_ASSETS_URL . 'element/figure64.png'; ?>" height="174" width="173" data-wow-delay="300ms" data-wow-duration="800ms" alt=""></li>
			<li class="motion-effects5"></li>
			<li class="motion-effects6"></li>
		</ul>
		<div class="image-item">
			<?php echo wp_kses_post($getimg);?>
		</div>
		<?php if( $data['info_title'] || $data['phone_number']){ ?>
			<div class="image-info">
				<div class="phone-icon"><i class="fas fa-phone-alt"></i></div>
				<ul class="phone-text">
					<?php if($data['info_title']){?>
						<li><?php echo wp_kses_post( $data['info_title'] ); ?></li>
					<?php } ?>
					<?php if($data['phone_number']){?>
						<li class="number"><a href="tel:<?php echo wp_kses_post( $data['phone_number'] ); ?>"><?php echo wp_kses_post( $data['phone_number'] ); ?></a></li>
					<?php } ?>
				</ul>
			</div>
		<?php } ?>
	</div>
</div>