<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Utils;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Counter extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = __( 'RT Counter', 'finbuzz-core' );
		$this->rt_base = 'rt-counter';
		parent::__construct( $data, $args );
	}

	private function rt_load_scripts(){
		wp_enqueue_script( 'appear' );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Style 1', 'finbuzz-core' ),
					'style2' => esc_html__( 'Style 2', 'finbuzz-core' ),
					'style3' => esc_html__( 'Style 3', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'iconalign',
				'label'   => esc_html__( 'Counter Align', 'finbuzz-core' ),
				'options' => array(
					'left' => esc_html__( 'left', 'finbuzz-core' ),
					'center' => esc_html__( 'Center', 'finbuzz-core' ),
					'right' => esc_html__( 'Right', 'finbuzz-core' ),
				),
				'default' => 'left',
				'condition'   => array( 'style' => array('style1','style3')),
			),
			
			/*Icon Start*/
			
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label_block'=>true,
				'label'   => esc_html__( 'Title', 'finbuzz-core' ),
				'default' => esc_html__( 'Organizations & Financial', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => esc_html__( 'Counter Number', 'finbuzz-core' ),
				'default' => 3000,
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'speed',
				'label'   => esc_html__( 'Animation Speed', 'finbuzz-core' ),
				'default' => 2000,
				'description' => esc_html__( 'The total duration of the count animation in milisecond eg. 5000', 'finbuzz-core' ),
			),
			array(
				'mode' => 'section_end',
			),
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_colors',
				'label'   => esc_html__( 'Colors', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .counter-style1 .success-count-wrap .count-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style2 .success-count-wrap .count-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style3 .success-count-wrap .count-text' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'counter_color',
				'label'   => esc_html__( 'Counter Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .counter-style1 .success-count-wrap .count' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style2 .success-count-wrap .count' => 'color: {{VALUE}}',
					'{{WRAPPER}} .counter-style3 .success-count-wrap .count' => 'color: {{VALUE}}',
				),
			),
			
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'title_size',
				'mode'       => 'responsive',
				'label'   => esc_html__( 'Title Font Size', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .counter-style1 .success-count-wrap .count-text' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style2 .success-count-wrap .count-text' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style3 .success-count-wrap .count-text' => 'font-size: {{VALUE}}px',
				),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'counter_size',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Counter Font Size', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .counter-style1 .success-count-wrap .count' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style2 .success-count-wrap .count' => 'font-size: {{VALUE}}px',
					'{{WRAPPER}} .counter-style2 .success-count-wrap .count' => 'font-size: {{VALUE}}px',
				),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$this->rt_load_scripts();
		
		switch ( $data['style'] ) {
			case 'style3':
			$template = 'counter-3';
			break;
			case 'style2':
			$template = 'counter-2';
			break;
			default:
			$template = 'counter-1';
			break;
		}

		return $this->rt_template( $template, $data );
	}
}