<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;



if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class RT_Parallax extends Widget_Base {
    private function rt_load_scripts(){
		wp_enqueue_script( 'tweenmax' );
        wp_enqueue_script( 'rt-wow' );
        wp_enqueue_style( 'animate' );
	}
    public function get_name() {
		return 'rt-parallax';
	}

	public function get_title() {
		return 'RT Parallax Animation';
	}

	public function get_icon() {
		return 'fa fa-registered';
	}

	public function get_categories() {
		return array( FINBUZZ_CORE_THEME_PREFIX . '-widgets' );
	}
	protected function _register_controls() {
		$this->start_controls_section(
			'sec_general',
			[
				'label' => esc_html__( 'General', 'finbuzz-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

	


		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'animated_image',
			[
				'label'   => __( 'Animated Image', 'finbuzz-core' ),
				'type'    => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'animation_list',
			[
				'label'  => __( 'Animated Image List', 'finbuzz-core' ),
				'type'   => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		$data = $this->get_settings();
        $this->rt_load_scripts();
		$animated_list = $data['animation_list'];
		if ( $animated_list ):
			$img_count = 1;
			foreach ( $animated_list as $list ) {
				if ( $list['animated_image']['id'] ) {
					?>
					<div class="motion-effects-wrap rt-parallax-img">
						<ul class="element-list d-none d-xl-block">
							<li class="motion-effects1">
							
								<img
											src="<?php echo esc_url( $list['animated_image']['url'] ); ?>"
											alt="<?php echo esc_attr( 'Animated Image' ) ?>"
									>
						
							</li>
						</ul>
					</div>
                   
					<?php
					$img_count ++;
				}
			}
		endif;
	}

}