<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Finbuzz_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;
if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Team extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Team', 'finbuzz-core' );
		$this->rt_base = 'rt-team';
		$this->rt_translate = array(
			'cols'  => array(
				'12' => esc_html__( '1 Col', 'finbuzz-core' ),
				'6'  => esc_html__( '2 Col', 'finbuzz-core' ),
				'4'  => esc_html__( '3 Col', 'finbuzz-core' ),
				'3'  => esc_html__( '4 Col', 'finbuzz-core' ),
				'2'  => esc_html__( '6 Col', 'finbuzz-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$terms = get_terms( array( 'taxonomy' => 'finbuzz_team_category', 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => esc_html__( 'All Categories', 'finbuzz-core' ) );

		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'finbuzz-core' ),
				'options' => array(
					'style1' => esc_html__( 'Team Grid Layout 1', 'finbuzz-core' ),
					'style3' => esc_html__( 'Team Grid Layout 2', 'finbuzz-core' ),
					'style4' => esc_html__( 'Team Grid Layout 3', 'finbuzz-core' ),
					'style5' => esc_html__( 'Team Grid Layout 4', 'finbuzz-core' ),
					'style6' => esc_html__( 'Team Grid Layout 5', 'finbuzz-core' ),
					'style2' => esc_html__( 'Team Slider Layout', 'finbuzz-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => esc_html__( 'Total number of items', 'finbuzz-core' ),
				'default' => 6,
				'description' => esc_html__( 'Write -1 to show all', 'finbuzz-core' ),
			),
			
			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat',
				'label'   => esc_html__( 'Categories', 'finbuzz-core' ),
				'options' => $category_dropdown,
				'default' => '0',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => esc_html__( 'Order By', 'finbuzz-core' ),
				'options' => array(
					'date'        => esc_html__( 'Date (Recents comes first)', 'finbuzz-core' ),
					'title'       => esc_html__( 'Title', 'finbuzz-core' ),
					'menu_order'  => esc_html__( 'Custom Order (Available via Order field inside Page Attributes box)', 'finbuzz-core' ),
				),
				'default' => 'date',
			),
			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'content_display',
				'label'       => esc_html__( 'Content Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'no',
				'description' => esc_html__( 'Show or Hide Content. Default: off', 'finbuzz-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'count',
				'label'   => esc_html__( 'Content Word count', 'finbuzz-core' ),
				'default' => 15,
				'description' => esc_html__( 'Maximum number of words', 'finbuzz-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'designation_display',
				'label'       => esc_html__( 'Designation Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Designation. Default: On', 'finbuzz-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'social_display',
				'label'       => esc_html__( 'Social Media Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Social Medias. Default: On', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style1' ))
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'read_more_button_display',
				'label'       => esc_html__( 'Read More Button Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide More Button . Default: On', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style2','style3'))
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'more_button_display',
				'label'       => esc_html__( 'More Button Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide More Button . Default: On', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style1','style3','style4','style5','style6'))
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'more_button',
				'label'   => esc_html__( 'More Button', 'finbuzz-core' ),
				'options' => array(
					'show'        => esc_html__( 'Show Read More', 'finbuzz-core' ),
					'hide'        => esc_html__( 'Show Pagination', 'finbuzz-core' ),
				),
				'default' => 'show',
				'condition'   => array( 'style' => array( 'style1','style3','style4','style5','style6'),'more_button_display'=>'yes' ),
			),
			array (
				'type'    => Controls_Manager::TEXT,
				'id'      => 'see_button_text',
				'label'   => esc_html__( 'Button Text', 'finbuzz-core' ),
				'condition'   => array( 'more_button' => array( 'show' ) ),
				'default' => esc_html__( 'MORE TEAMS', 'finbuzz-core' ),
				'condition'   => array( 'more_button' => array( 'show' ), 'style' => array( 'style1','style3','style4','style5','style6'), 'more_button_display'=>'yes' ),
			),
			array (
				'type'    => Controls_Manager::TEXT,
				'id'      => 'see_button_link',
				'label'   => esc_html__( 'Button Link', 'finbuzz-core' ),
				'condition'   => array( 'more_button' => array( 'show' ), 'style' => array( 'style1','style3','style4','style5'),'more_button_display'=>'yes'  ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'team_style3_shape',
				'label'       => esc_html__( 'Background Shape Display', 'finbuzz-core' ),
				'label_on'    => esc_html__( 'On', 'finbuzz-core' ),
				'label_off'   => esc_html__( 'Off', 'finbuzz-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Shape .Default: On', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style5' ))
			),
			array(
				'mode' => 'section_end',
			),

			//Style Option Start

			/*Team Title Style*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_style',
				'label'   => esc_html__( 'Team Title', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'team_title_typo',
				'label'   => esc_html__( 'Title Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .team-default .rtin-item .rtin-content .rtin-title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .team-default .rtin-item .rtin-content .rtin-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team-default .rtin-item .rtin-content .rtin-title a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_hover_color',
				'label'   => esc_html__( 'Title Hover Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .team-default .rtin-item .rtin-content-wrap:hover .rtin-content .rtin-title a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team-grid-style2 .rtin-item .rtin-content-wrap:hover .mask-wrap .rtin-content .rtin-title a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .team-default .rtin-item .rtin-content .rtin-title a:hover' => 'color: {{VALUE}}',
				),
			),
			
			array(
				'mode' => 'section_end',
			),


			/*Team Desingnation Style*/
			array(
				'mode'    => 'section_start',
				'id'      => 'designation_style',
				'label'   => esc_html__( 'Team Designation', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'team_designation_typo',
				'label'   => esc_html__( 'Designation Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .team-default .rtin-item .rtin-content .rtin-designation',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'team_designation_color',
				'label'   => esc_html__( 'Designation Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .team-default .rtin-item .rtin-content .rtin-designation' => 'color: {{VALUE}}',
					
				),
			),
			
			array(
				'mode' => 'section_end',
			),

			/*Team Content Style*/
			array(
				'mode'    => 'section_start',
				'id'      => 'content_style',
				'label'   => esc_html__( 'Team Content', 'finbuzz-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'team_content_typo',
				'label'   => esc_html__( 'Content Typo', 'finbuzz-core' ),
				'selector' => '{{WRAPPER}} .team-default .rtin-item .rtin-content p',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'team_content_color',
				'label'   => esc_html__( 'Content Color', 'finbuzz-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .team-default .rtin-item .rtin-content p' => 'color: {{VALUE}}',
					
				),
			),
			
			array(
				'mode' => 'section_end',
			),

			// Animation style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_animation_style',
	            'label'   => esc_html__( 'Animation', 'finbuzz-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation',
				'label'   => esc_html__( 'Animation', 'finbuzz-core' ),
				'options' => array(
					'wow'        => esc_html__( 'On', 'finbuzz-core' ),
					'hide'        => esc_html__( 'Off', 'finbuzz-core' ),
				),
				'default' => 'wow',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation_effect',
				'label'   => esc_html__( 'Entrance Animation', 'finbuzz-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'finbuzz-core' ),
					'bounce' => esc_html__( 'bounce', 'finbuzz-core' ),
					'flash' => esc_html__( 'flash', 'finbuzz-core' ),
					'pulse' => esc_html__( 'pulse', 'finbuzz-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'finbuzz-core' ),
					'shakeX' => esc_html__( 'shakeX', 'finbuzz-core' ),
					'shakeY' => esc_html__( 'shakeY', 'finbuzz-core' ),
					'headShake' => esc_html__( 'headShake', 'finbuzz-core' ),
					'swing' => esc_html__( 'swing', 'finbuzz-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'finbuzz-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'finbuzz-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'finbuzz-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'finbuzz-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'finbuzz-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'finbuzz-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'finbuzz-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'finbuzz-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'finbuzz-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'finbuzz-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'finbuzz-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'finbuzz-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'finbuzz-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'finbuzz-core' ), 
                ),
				'default' => 'fadeInUp',
				'condition'   => array('animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'delay',
				'label'   => esc_html__( 'Delay', 'finbuzz-core' ),
				'default' => '0.2',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'duration',
				'label'   => esc_html__( 'Duration', 'finbuzz-core' ),
				'default' => '0.8',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'mode' => 'section_end',
			),

			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => esc_html__( 'Number of Responsive Columns', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style1','style3','style4','style5','style6') ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => esc_html__( 'Desktops: > 1199px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
				
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => esc_html__( 'Desktops: > 767px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => esc_html__( 'Tablets: < 767px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   => esc_html__( 'Phones: < 575px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   => esc_html__( 'Small Phones: < 480px', 'finbuzz-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
			
			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'finbuzz-core' ),
				'condition'   => array( 'style' => array('style2' ) ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'finbuzz-core' ),
				'default'     => 'off',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'finbuzz-core' ),
				'default'     => 'off',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_pagination',
				'label'       => esc_html__( 'Pagination', 'finbuzz-core' ),
				'default'     => 'yes',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'centered_slide',
				'label'       => esc_html__( 'Center Slide', 'finbuzz-core' ),
				'default'     => 'false',
				'condition'   => array( 'style' => array( 'style2') ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'slider_per_group',
				'label'       => esc_html__( 'Slides Per Group', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'autoplayspeed',
				'label'       => esc_html__( 'Autoplay speed', 'finbuzz-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10000,
                        'step' => 500,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2000,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'speed',
				'label'       => esc_html__( 'Slider Speed', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10000,
                        'step' => 500,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 2000,
                ],
				'condition'   => array( 'style' => array( 'style2') ),
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'space',
				'label'       => esc_html__( 'Inter slider spacing', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 30,
                ],
				'condition'   => array( 'style' => array( 'style2') ),
			),

			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item',
				'label'       => esc_html__( 'Desktop items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'medium_item',
				'label'       => esc_html__( 'Medium Desktop items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 6,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
			),
			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item_tablet',
				'label'       => esc_html__( 'Tablet items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
				'condition'   => array( 'style' => array( 'style2') ),
			),

			array(
				'type'        => Controls_Manager::SLIDER,
				'id'          => 'item_mobile',
				'label'       => esc_html__( 'Mobile items', 'finbuzz-core' ),
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 10,
                        'step' => 1,
                    ],
                ],
                'size_units' => [ 'px'],
                'default' => [
                    'size' => 1,
                ],
				'condition'   => array( 'style' => array( 'style2') ),
			),
			
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		
		switch ( $data['style'] ) {
			case 'style6':
			$template = 'team-grid-5';
			break;
			case 'style5':
			$template = 'team-grid-4';
			break;
			case 'style4':
			$template = 'team-grid-3';
			break;
			case 'style3':
			$template = 'team-grid-2';
			break;
			case 'style2':
			$template = 'team-slider';
			break;
			default:
			$template = 'team-grid-1';
			break;
		}
		
		return $this->rt_template( $template, $data );
	}
}