<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$finbuzz_socials = FinbuzzTheme_Helper::socials();
?>
<div id="tophead" class="header-top-bar align-items-center">
	<div class="container">
		<div class="d-flex align-items-center justify-content-between">
			<?php if(FinbuzzTheme::$options['email'] || FinbuzzTheme::$options['address'] ): ?>
				<div class="topbar-left">
					<?php if ( FinbuzzTheme::$options['address'] ) { ?>
						<div class="header-location header-item">
						<i class="fas fa-map-marker-alt"></i><?php echo wp_kses( FinbuzzTheme::$options['address'] , 'alltext_allow' );?>
						</div>
					<?php } ?>
					<?php if ( !empty(FinbuzzTheme::$options['email'])) { ?>
						<div class="header-email header-item">
						<i class="far fa-envelope"></i><a href="mailto:<?php echo esc_attr( FinbuzzTheme::$options['email'] );?>"><?php echo wp_kses( FinbuzzTheme::$options['email'] , 'alltext_allow' );?></a>
						</div>
					<?php } ?>
				</div>
			<?php endif; ?>
			<?php if ( (FinbuzzTheme::$options['phone'] && FinbuzzTheme::$options['top_bar_phone_show']) || $finbuzz_socials ) { ?>
				<div class="topbar-right">
					<?php if ( FinbuzzTheme::$options['phone'] && FinbuzzTheme::$options['top_bar_phone_show'] ) { ?>
						<?php $header_hotline_txt = finbuzzTheme::$options['header_hotline_txt'];
							  $header_hotline_txt.=":";
						?>
						<div class="header-phone header-item">
							<i class="fas fa-phone-alt"></i><span><?php if($header_hotline_txt){ echo esc_html( $header_hotline_txt ); } ?></span><a href="tel:<?php echo esc_attr(FinbuzzTheme::$options['phone']) ?>"><?php echo wp_kses( FinbuzzTheme::$options['phone'] , 'alltext_allow' ); ?></a>
						</div>
					<?php } ?>
					<?php if ( $finbuzz_socials ) { ?>
						<ul>
							<li class="topbar-social">
							<div class="social-icon">
							<?php foreach ( $finbuzz_socials as $finbuzz_social ): ?>
								<a target="_blank" href="<?php echo esc_url( $finbuzz_social['url'] );?>"><i class="fab <?php echo esc_attr( $finbuzz_social['icon'] );?>"></i></a>
							<?php endforeach; ?>
							</div>
							</li>
						</ul>
					<?php } ?>	
				</div>
			<?php } ?>	
		</div>
	</div>
</div>