<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$nav_menu_args = FinbuzzTheme_Helper::nav_menu_args();

if( !empty( FinbuzzTheme::$options['logo'] ) ) {
    $logo_dark = wp_get_attachment_image( FinbuzzTheme::$options['logo'], 'full' );
    $finbuzz_dark_logo = $logo_dark;
}else {
    $finbuzz_dark_logo = "<img width='600' height='218' src='" . FINBUZZ_IMG_URL . 'logo-dark.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "' loading='lazy'>"; 
}

?>

<div class="rt-header-menu mean-container" id="meanmenu">

    <?php if(FinbuzzTheme::$options['mobile_header_menu']) { ?>
        <?php get_template_part('template-parts/header/mobile', 'topbar');?>
    <?php } ?>
    <?php ?>
    <div id="mobile-sticky-placeholder"></div>
    <div class="mobile-mene-bar" id="mobile-men-bar">
        <div class="mean-bar">
            <a href="<?php echo esc_url(home_url('/'));?>"><?php echo wp_kses( $finbuzz_dark_logo, 'alltext_allow' ); ?></a>
            <span class="sidebarBtn ">
                <span class="bar"></span>
                <span class="bar"></span>
                <span class="bar"></span>
                <span class="bar"></span>
            </span>
        </div>
    
        <div class="rt-slide-nav">
            <div class="offscreen-navigation">
                <?php wp_nav_menu( $nav_menu_args );?>
            </div>
        </div>
    </div>
</div>
